/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.install.commons.swing.MessageDialog;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Option;
import oracle.sysman.oii.oiif.oiifm.OiifmAlertHandler;

public class DefaultAlertHandler
implements OiifmAlertHandler {
    private String title;
    private Component owner;

    public DefaultAlertHandler() {
        this(null, null);
    }

    public DefaultAlertHandler(Component owner) {
        this(owner, null);
    }

    public DefaultAlertHandler(Component owner, String title) {
        this.owner = owner;
        this.title = title;
    }

    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity, boolean selectable) {
        Level level;
        switch (severity) {
            case 10: {
                level = Level.WARNING;
                break;
            }
            case 20: {
                level = Level.SEVERE;
                break;
            }
            default: {
                level = Level.INFO;
            }
        }
        switch (alertType) {
            case 30: {
                level = Level.WARNING;
                break;
            }
            case 40: 
            case 60: {
                level = Level.WARNING;
                break;
            }
            case 50: {
                level = Level.SEVERE;
            }
        }
        ArrayList<MessageDialog.CommonOption> options = new ArrayList<MessageDialog.CommonOption>();
        if ((userChoices & 1) == 1) {
            options.add(MessageDialog.CommonOption.YES);
        }
        if ((userChoices & 2) == 2) {
            options.add(MessageDialog.CommonOption.NO);
        }
        if ((userChoices & 4) == 4) {
            options.add(MessageDialog.CommonOption.CANCEL);
        }
        MessageDialog.CommonOption defaultOption = MessageDialog.CommonOption.OK;
        if (options.size() <= 1) {
            options.clear();
            options.add(MessageDialog.CommonOption.OK);
        } else {
            switch (defaultChoice) {
                case 1: {
                    defaultOption = MessageDialog.CommonOption.YES;
                    break;
                }
                case 2: {
                    defaultOption = MessageDialog.CommonOption.NO;
                    break;
                }
                case 4: {
                    defaultOption = MessageDialog.CommonOption.CANCEL;
                    break;
                }
                default: {
                    defaultOption = MessageDialog.CommonOption.NO;
                }
            }
        }
        DefaultStatusMessage message = new DefaultStatusMessage(level, msg);
        MessageDialog.CommonOption option = (MessageDialog.CommonOption)StandardDialog.showMessage(this.owner, title == null ? this.title : title, message, defaultOption, options.toArray(new Option[0]));
        if (option == MessageDialog.CommonOption.OK) {
            option = MessageDialog.CommonOption.YES;
        }
        int returnCode = 0;
        switch (option) {
            case OK: 
            case YES: {
                returnCode = 1;
                break;
            }
            case NO: {
                returnCode = 2;
                break;
            }
            default: {
                returnCode = 4;
            }
        }
        return returnCode;
    }

    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity) {
        return this.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity, false);
    }
}

